package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaOS3CustomDao;
import com.ejie.ab04b.dao.custom.TramiteOS3CustomDao;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0495s00ServiceImpl generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

@Service(value = "ab0495s00Service")
public class TramiteOS3ServiceImpl implements TramiteOS3Service {

	@Autowired()
	private TramiteOS3CustomDao ab0495s00Dao;
	@Autowired()
	private TareaOS3CustomDao tareaOS3Dao;

	/**
	 * Inserts a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteOS3 add(TramiteOS3 ab0495s00) {
		return this.ab0495s00Dao.add(ab0495s00);
	}

	/**
	 * Updates a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteOS3 update(TramiteOS3 ab0495s00) {
		return this.ab0495s00Dao.update(ab0495s00);
	}

	/**
	 * Finds a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	public TramiteOS3 find(TramiteOS3 ab0495s00) {
		return (TramiteOS3) this.ab0495s00Dao.vfind(ab0495s00);
	}

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os3
	 *            OS3
	 *  TramiteOS3
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os3 the os 3
	 * @return the tramite OS 3
	 */
	public TramiteOS3 findLastTramiteByTipo(Long idTipoTramite, OS3 os3) {
		return (TramiteOS3) this.ab0495s00Dao.findLastTramiteByTipo(
				idTipoTramite, os3);
	}

	/**
	 * Busca un trámite y le carga su lista de tareas asociadas.
	 * 
	 *  tramiteOS3            TramiteOS3
	 *  TramiteOS3
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @return the tramite OS 3
	 */
	public TramiteOS3 findConTareas(TramiteOS3 tramiteOS3) {

		TramiteOS3 tramiteOS3Aux = (TramiteOS3) this.ab0495s00Dao
				.vfind(tramiteOS3);

		TareaOS3 filterTareaOS3 = new TareaOS3();
		filterTareaOS3.setTramiteOS3(tramiteOS3Aux);
		List<TareaOS3> listaTareas = this.tareaOS3Dao.vfindAll(filterTareaOS3,
				null);

		tramiteOS3Aux.setListaTareas(listaTareas);

		return tramiteOS3Aux;
	}

	/**
	 * Deletes a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TramiteOS3 ab0495s00) {
		this.ab0495s00Dao.remove(ab0495s00);
	}

	/**
	 * Finds a list of rows in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0495s00>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TramiteOS3> findAll(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TramiteOS3>) this.ab0495s00Dao.vfindAll(ab0495s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0495s00 table using like.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0495s00>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TramiteOS3> findAllLike(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TramiteOS3>) this.ab0495s00Dao.findAllLike(ab0495s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0495s00 table.
	 * 
	 *  filterAb0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0495s00>
	 *
	 * @param filterAb0495s00 the filter ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TramiteOS3> filter(TramiteOS3 filterAb0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TramiteOS3> listaAb0495s00 = this.ab0495s00Dao
				.findAllImprimirDocsOS3Like(filterAb0495s00, jqGridRequestDto,
						false);
		Long recordNum = this.ab0495s00Dao.findAllLikeImprimirDocsOS3Count(
				filterAb0495s00 != null ? filterAb0495s00 : new TramiteOS3(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TramiteOS3>> reorderSelection = this.ab0495s00Dao
					.reorderSelection(filterAb0495s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TramiteOS3>(jqGridRequestDto,
					recordNum, listaAb0495s00, reorderSelection);
		}
		return new JQGridResponseDto<TramiteOS3>(jqGridRequestDto, recordNum,
				listaAb0495s00);
	}

	/**
	 * Searches rows in the Ab0495s00 table.
	 * 
	 *  filterAb0495s00
	 *            Ab0495s00
	 *  searchAb0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0495s00>>
	 *
	 * @param filterAb0495s00 the filter ab 0495 s 00
	 * @param searchAb0495s00 the search ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TramiteOS3>> search(TramiteOS3 filterAb0495s00,
			TramiteOS3 searchAb0495s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0495s00Dao.search(filterAb0495s00, searchAb0495s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0495s00 table.
	 * 
	 *  filterAb0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0495s00 the filter ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TramiteOS3 filterAb0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0495s00Dao.reorderSelection(filterAb0495s00,
				jqGridRequestDto, startsWith);
	}

}
